Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function GetTickCount Lib "kernel32" () As Long
'Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Long) As Integer
'Private Declare Function GetCurrentThreadId Lib "kernel32" () As Long


Public Const WH_CALLWNDPROC = 4
Public Const WH_CBT = 5
Public Const WH_DEBUG = 9
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_GETMESSAGE = 3
Public Const WH_HARDWARE = 8
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_JOURNALRECORD = 0
Public Const WH_KEYBOARD = 2
Public Const WH_MAX = 11
Public Const WH_MIN = (-1)
Public Const WH_MOUSE = 7
Public Const WH_MSGFILTER = (-1)
Public Const WH_SHELL = 10
Public Const WH_SYSMSGFILTER = 6

Public Const MSGF_DIALOGBOX = 0
Public Const MSGF_NEXTWINDOW = 6
Public Const MSGF_SCROLLBAR = 5
Public Const MSGF_MENU = 2

Public Const MSGF_MAINLOOP = 8      'Not used with MsgFilter Hook
Public Const MSGF_MAX = 8           'Not used with MsgFilter Hook
Public Const MSGF_MESSAGEBOX = 1    'Not used with MsgFilter Hook
Public Const MSGF_MOVE = 3          'Not used with MsgFilter Hook
Public Const MSGF_SIZE = 4          'Not used with MsgFilter Hook
Public Const MSGF_DDEMGR = &H8001   'Not used with MsgFilter Hook
Public Const MSGF_USER = 4096       'Not used with MsgFilter Hook


Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4


Public Type DEBUGHOOKINFO
        hModuleHook As Long
        Reserved As Long
        lParam As Long
        wParam As Long
        code As Long
End Type

Public Type POINTAPI
        x As Long
        y As Long
End Type

Public Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type


'WINUSER.H contains all these constants, structs, etc...
'WINABLE.H more info on hooks


Private lpPrevWndProc As Long
Private lpPrevDBGWndProc As Long

Public IsHooked As Boolean
Public IsDBGHooked As Boolean


'----------------------------------
' SET FOREGROUND IDLE FILTER HOOK
'----------------------------------
Public Sub SetIdleHook()
    If IsHooked Then
        MsgBox "Don't hook it twice without unhooking, or you will be unable to unhook it."
    Else
        lpPrevWndProc = SetWindowsHookEx(WH_FOREGROUNDIDLE, AddressOf IdleProc, 0, App.ThreadID)

        IsHooked = True
        
        
        'PROBLEM: FIXED by using app.hinstance
        'A global hook is being set with a NULL hInstance parameter
        '   or a thread-specific hook is being set for a thread
        '   that is not in the setting application.
    End If
End Sub

Public Sub RemoveIdleHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(lpPrevWndProc)
    IsHooked = False
End Sub


Public Function IdleProc(ByVal uCode As Long, ByVal wParam As Long, lParam As Long) As Long
    If uCode < 0 Then
        IdleProc = CallNextHookEx(lpPrevWndProc, uCode, wParam, lParam)
    Else
        Select Case uCode
            Case HC_ACTION
                Form2.Text1.Text = Form2.Text1.Text & "IDLE" & vbNewLine
            Case Else
                Form2.Text1.Text = Form2.Text1.Text & "else    uCode:" & uCode & vbNewLine
        End Select
        
            
            
        IdleProc = CallNextHookEx(lpPrevWndProc, uCode, wParam, lParam)
    End If
End Function




'-----------------------------
' SET DEBUG FILTER HOOK
'-----------------------------
Public Sub SetDebugHook()
    If IsDBGHooked Then
        MsgBox "Don't hook it twice without unhooking, or you will be unable to unhook it."
    Else
        lpPrevDBGWndProc = SetWindowsHookEx(WH_DEBUG, AddressOf DebugProc, 0, App.ThreadID)

        IsDBGHooked = True
        
        
        'PROBLEM: FIXED by using app.hinstance
        'A global hook is being set with a NULL hInstance parameter
        '   or a thread-specific hook is being set for a thread
        '   that is not in the setting application.
    End If
End Sub

Public Sub RemoveDebugHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(lpPrevDBGWndProc)
    IsDBGHooked = False
End Sub


Public Function DebugProc(ByVal uCode As Long, ByVal wParam As Long, lParam As DEBUGHOOKINFO) As Long
    
    'If nCode is HC_ACTION, the hook procedure must process the message
    
    If uCode < 0 Then
        DebugProc = CallNextHookEx(lpPrevDBGWndProc, uCode, wParam, lParam)
    Else
        Select Case wParam
            Case WH_CALLWNDPROC
                Form2.Text1.Text = Form2.Text1.Text & "WH_CALLWNDPROC    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_CBT
                Form2.Text1.Text = Form2.Text1.Text & "WH_CBT    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_DEBUG
                Form2.Text1.Text = Form2.Text1.Text & "WH_DEBUG    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_FOREGROUNDIDLE
                Form2.Text1.Text = Form2.Text1.Text & "WH_FOREGROUNDIDLE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_GETMESSAGE
                Form2.Text1.Text = Form2.Text1.Text & "WH_GETMESSAGE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_HARDWARE
                Form2.Text1.Text = Form2.Text1.Text & "WH_HARDWARE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_JOURNALPLAYBACK
                Form2.Text1.Text = Form2.Text1.Text & "WH_JOURNALPLAYBACK    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
    '        This will fire too many times to be of use
    '        Why does this fire - no journal hook has been installed
            Case WH_JOURNALRECORD
    '            Form2.Text1.Text = Form2.Text1.Text & "WH_JOURNALRECORD" & vbNewLine
            Case WH_KEYBOARD
                Form2.Text1.Text = Form2.Text1.Text & "WH_KEYBOARD    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_MAX
                Form2.Text1.Text = Form2.Text1.Text & "WH_MAX    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_MIN
                Form2.Text1.Text = Form2.Text1.Text & "WH_MIN    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
    '        This will fire too many times to be of use
            Case WH_MOUSE
    '            Form2.Text1.Text = Form2.Text1.Text & "WH_MOUSE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_MSGFILTER
                Form2.Text1.Text = Form2.Text1.Text & "WH_MSGFILTER    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_SHELL
                Form2.Text1.Text = Form2.Text1.Text & "WH_SHELL    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_SYSMSGFILTER
                Form2.Text1.Text = Form2.Text1.Text & "WH_SYSMSGFILTER    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case Else
                Form2.Text1.Text = Form2.Text1.Text & "else    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
        End Select
        
            
        'To prevent the system from calling the hook, the hook procedure must return a nonzero value
        DebugProc = CallNextHookEx(lpPrevDBGWndProc, uCode, wParam, lParam)
    End If
End Function






'****************************************************************
'  WH_DEBUG hook procedure
'****************************************************************
'
'LRESULT CALLBACK DebugProc(int nCode, WPARAM wParam, LPARAM lParam)
'{
'    CHAR szBuf[128];
'    HDC hdc;
'    static int c = 0;
'    int cch;
'
'    if (nCode < 0)  // do not process message
'        return CallNextHookEx(myhookdata[DEBUG].hhook, nCode, wParam, lParam);
'
'    hdc = GetDC(hwndMain);
'    switch (nCode)
'    {
'        case HC_ACTION:
'            cch = wsprintf(szBuf, "DEBUG - nCode: %d, tsk: %ld, %d times   ", nCode,wParam, c++);
'            TextOut(hdc, 2, 55, szBuf, cch);
'            break;
'        default:
'            break;
'    }
'
'    ReleaseDC(hwndMain, hdc);
'
'    return CallNextHookEx(myhookdata[DEBUG].hhook, nCode, wParam, lParam);
'}
